<?php

namespace App\Http\Controllers;

use App\Models\Modul;
use App\Models\Ongkir;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;

class OngkirController extends Controller
{
    public function index()
    {
        $ongkir = Ongkir::latest()->get();
        $data = [
            'title' => 'Ramizah Store | Ongkos Kirim',
            'page' => 'Ongkos Kirim',
            'menuActive' => 'ongkir',
            'menuOpen' => 'ongkir',
        ];
        return view('admin.ongkir.ongkir', compact('data', 'ongkir'))->with('no', 1);
    }

    public function store(Request $request): RedirectResponse
    {
        $request->validate(
            [
                'kd_ongkir'  => 'required|unique:ongkirs,kd_ongkir',
                'berat'   => 'required',
                'harga'   => 'required',
                'rute'   => 'required',
            ],
            [
                'required' => 'Form wajib diisi!',
                'unique' => 'Kode sudah pernah diinputkan, silahkan input Kode lain!',
            ]
        );

        Ongkir::create([
            'kd_ongkir' => $request->kd_ongkir,
            'berat' => $request->berat,
            'harga' => $request->harga,
            'rute' => $request->rute,
        ]);

        return redirect()->route('ongkir.index')->with(['success' => 'Data Berhasil Disimpan!']);
    }

    public function update(Request $request): RedirectResponse
    {

        if ($request->kdlama != $request->kd_ongkir) {
            $rule = 'required|unique:ongkirs,kd_ongkir';
        } else {
            $rule = 'required';
        }

        $request->validate(
            [
                'kd_ongkir'         =>  $rule,
                'berat'   => 'required',
                'harga'   => 'required',
                'rute'   => 'required',
            ],
            [
                'required' => 'Form wajib diisi!',
                'unique' => 'Kode sudah pernah diinputkan, silahkan input Kode lain!',
            ]
        );

        $id = $request->id;

        $ongkir = Ongkir::findOrFail($id);

        $ongkir->update([
            'kd_ongkir' => $request->kd_ongkir,
            'berat' => $request->berat,
            'harga' => $request->harga,
            'rute' => $request->rute,
        ]);

        return redirect()->route('ongkir.index')->with(['success' => 'Edit Data Berhasil Disimpan!']);
    }

    public function destroy($id)
    {
        Ongkir::findOrFail($id)->delete();
        return redirect()->route('ongkir.index')->with(['success' => 'Data Berhasil Dihapus!']);
    }

    public function bank()
    {
        $bank = Modul::where('kode', 'BANK')->latest()->get();
        $data = [
            'title' => 'Ramizah Store | Rekening Pembayaran',
            'page' => 'Rekening Pembayaran',
            'menuActive' => 'bank',
            'menuOpen' => 'bank',
        ];
        return view('admin.ongkir.bank', compact('data', 'bank'))->with('no', 1);
    }

    public function bank_tambah(Request $request)
    {
        Modul::create([
            'kode' => 'BANK',
            'judul' => $request->nama_bank,
            'isi' => $request->no_rek,
            'link' =>  $request->atas_nama,
            'gambar' => '',
            'status' => 'Y',
        ]);
        return redirect('/bank')->with(['success' => 'Data Berhasil Disimpan!']);
    }

    public function update_bank(Request $request)
    {
        $id = $request->id;

        $bank = Modul::findOrFail($id);
        $bank->update([
            'judul' => $request->nama_bank,
            'isi' => $request->no_rek,
            'link' =>  $request->atas_nama,
        ]);
        return redirect('/bank')->with(['success' => 'Edit Data Berhasil Disimpan!']);
    }

    public function destroy_bank($id)
    {
        Modul::findOrFail($id)->delete();
        return redirect('/bank')->with(['success' => 'Data Berhasil Dihapus!']);
    }
}
